# Glock 26 Gen 3 Pistol Frame and DIY Rail System

#### Author
FreeMenDontAsk

#### Version
1.0

#### Description 
This is the Glock 26 Gen 3 Pistol Frame and DIY Rail System by FreeMenDontAsk. The system relies on a DIY metal rail system which is added to a printed frame.

These can be bought from spookyrails.com or riptiderails.com - both sites share the vision and support the devs.

#### Instruction Videos
A set of instructional videos were made for FreeMenDontAsk's 
Glock 17 Gen 3 Pistol Frame and DIY Rail System. Below is a list of said videos. This Glock 26 design is similar in construction and so the follow videos may be of use.

##### FreeMan's Glock 17 Assembly Tutorial Playlist:
https://www.youtube.com/playlist?list=PLZzfUB_pwdJ58NWjy10gbhjhukDxxcxUf

##### FreeMan's Glock 17 Assembly Tutorial Parts 1-3 (Same as above Playlist):
* Part 1 - https://gunstreamer.com/watch/U3T4bJjzVALzZdc
* Part 2 - https://gunstreamer.com/watch/4rCjJh2MX6gTlLG
* Part 3a - https://gunstreamer.com/watch/4HD8mNDIdbbMwQS
* Part 3b - https://gunstreamer.com/watch/115JAEQDa87zTBK
* Part 3c - https://gunstreamer.com/watch/uBbhEQt7i2CSkOI

#### Tools and Parts List
Below is a list of tools, parts and materials used to complete this project.

##### Materials
* Epoxy 
* Sandpaper
* .75"x1" bar stock of Aluminum, Steel or Stainless Steel
* M2.5 x 8mm screws (M2 screws can be used but M2.5 is recommended)

##### Tools
* Dremel Tool (Dremel 3000 works well)
* Cutting wheels, sanding wheels, polishing wheel and compound
* Metal files, including small diameter rat-tailed file
* Manual Mill, CNC Mill or X-Y Vise on a Drill Press (to mill the rails)
* M2.5 tap + 2.05mm drill bit
* Drill (battery, corded, or hand)
* Small and medium sized screwdriver
* Small punches

##### Required Parts
* Complete G26 Parts Kit
* DIY Rails

#### The Rails
Reference the G26 Front and Rear Rail Drawings in the SpecSheets folder for the technical dimensions of the DIY rails. The rails use a roll pin and screws in the rear. Rails can me made in Aluminum, Steel, or Stainless Steel. 

The specs for the rails are minimum dimensions; aim to overshoot them slightly if you are manually milling them. The dimensions given are for CNC or a milling setup. DO NOT UNDERSHOOT THE GIVEN DIMENSIONS. You can always remove more material if the slide does not fit, it is much harder to material after the fact.

#### Print Settings
* Print in PLA or ABS
* Infill: 99% infill
* Orientation: Print frame upside down

Note: PLA will not stand up to hot environments. The gun itself will not hold enough heat to hurt the frame but a PLA frame sitting in a hot car will damage it.

##### Post Print Finishing of Frame
Refer to the instruction videos above. In general, it is the same process as putting a normal Glock together but with the required rails. The only part that really needs hand fitting is the locking block. The locking block needs to be tight, so it may take a bit to get situated correctly. 

#### 4. Assembly Notes
Important items to note about assembly are in the instructional videos. Below are some additional notes:

* Holes must be drilled to size. Do not try to hammer the pins in. They should go in easy.
* If your front rail block is loose, consider a little JB weld or epoxy on the sides and front to steady it. A loose front rail can cause issues.
* If the locking block pin holes do not line up, do not try and force the pins through.
* Yes, the rear rails are necessary; do not fire the gun without them. 
* Check your rail height by pressing down on the barrel when the gun is in battery. It should depress some but should not unlock the action. If the action unlocks, your rails are way too high. Watch the machining video for more information.

General Assembly: 
* Add front rail section
* Add locking block
* Add slide lock
* Add trigger bar/housing assembly
* Remove trigger bar/housing assembly once fitment is verified
* Screw in rear rails
* Reinstall trigger assembly
* Pin in the locking block, trigger assembly, and slide stop
* Ensure the rails are flat/on the same plane using a straight edge
* Ensure fitment of the slide with barrel and spring removed
* Ensure fitment and function of the pistol with barrel and spring installed
* Function test! Function test! Function test! Rack that slide real hard.