# IvanTheTroll Presents
## The Menendez Mag + Mini-Menendez Mag
### 3D Printable G17 + G19 Magazine Bodies, Followers, Floorplates, and Locking Tabs
### Version 1.1 Notes: Added "EZ" locking tab/baseplate to enable a 9mm round to take down the mag.

This project represents over 500 hours of time in CAD, over 250 hours of 3D printer running time, over 1000 rounds of ammo, all over the course of six months.
The end result is worth it - 3D printable Glock mags that cost next to nothing to print, last several hundred rounds, can be printed on essentially any FDM/FFF printer, and require little to no post-processing.
Below are instructions on printing and troubleshooting the Menendez Mag series.

### What you'll need:

     - PLA (Optionally Nylon [645 is tested good], PETG).  I recommend PLA, as it is cheap, easy to print, and is what I designed the mag in.
     - A printer capable of printing PLA (or the plastic you choose to use).  The Creality Ender 3 is capable of printing these mags, and costs only 200 bucks.  
	   A guide on dialing in and making the most use of your Ender 3 is coming soon. Look for it on our regular communication channels such as our Keybase (keybase.io/team/det_disp).
     - An appropriate Glock mag spring - use factory-spec Glock mag springs (not PMAG springs).  
	   These can be had cheap from Amazon, The Official Glock Store (NOT Glockstore.com!!!), Wilson Combat, AliExpress (the springs usually come with a baseplate extension).
         - A tool to allow bending your own Mag springs is in development, but it isn't a priority since Glock mag springs can be bought worldwide, even in countries that control magazines as if they were regulated firearm parts.
		
### Print Settings

     - Orientations
	     Note that the included STLs are scaled and oriented correctly!
	 
         - Print mag body upright, no supports.
         - Print baseplate bottom down, no supports.
         - Print locking tab bottom down, no supports.
         - Print follower upside down, with the tallest flat portion to the print bed.  Use supports from print bed, but not full supports.
	
	 - Print Settings
		 I recommend that you print in eSun PLA+, don't come crying when you print it in ABS and it works poorly.
		 
		 - Nozzle Temp             - 230C
		 - Bed Temp                - 60C
		 - Brim                    - ON
		 - Supports                - NONE
		 - Layer Height            - 0.15mm
		 - Shells (aka perimeters) - 4 inner/outer (this may not be necessary, but works well for me)
		 - Bed prep                - Gluestick, optionally on top of Kapton Tape.
	
### Troubleshooting 
		 Mags may feed poorly at first.  This is because the mag lips are reinforced beyond what PMAGs or Factory mags are.  
		 Dry cycle (or live fire) a full mag through it if it has issues feeding.  This will solve rough feeding issues. 
		 Printed mags will wear out.  Their rate of wear depends entirely on the user.  
		 If you feed rounds into the mag in a manner that drags the round along the mag lips, you will cause excess wear on the mag lips, which will wear the mag out.
		 Testing has netted a mag that is at 400 rounds and counting, making sure to load each mag carefully as to not scrape the rounds along the mag lips when loading.
		 

Want to join the movement?  Head over to keybase.io/team/det_disp.
