# Photon's BPW System
by photon9101

The Braced Pistol Weapon System (BPW) is a simple modification for any modern pistol using MIL-STD-1913 picatinny light rails.

##  Description

The Braced Pistol Weapon System (BPW) is a simple modification for any modern pistol using MIL-STD-1913 picatinny light rails. It is designed to be used braced against the arm, cheek, or strapped to the arm using the strap slots on the brace. It requires less than $15 of hardware and 4-5 hours of printing. It is based off the concepts in the SBA3 Brace by SB Tactical and the Flux Brace by Flux Defense. Though it is not approved by BATFE, it is based off designs currently on the market as pistol braces. It is not intended for use as a shoulder stock. It has a picatinny rail on the underside for use with a light, laser, or magazine holder.

## Materials Required
- 1/4" steel rod, approx 2.5 ft
- 2 6-32 nuts & 2 6-32 x 3/8" screws
- 1 10-24x3/4" screw
- 1 Velcro or nylon strap, approx 1 ft

## Tools Required
- 1/8" drill bit and drill
- A file or grinding wheel or sandpaper OR a 1/4" drill bit
- Epoxy or JB Weld

## Print Settings
- **For all parts, PLA or PLA+ are recommended.** (PLA bends and locks into the screws better than PLA+, but may be more prone to the holes stripping out.)
- **Print with no supports, 40% infill.** (The mounting block halves may need to be rotated to ensure the points face upwards.)

## Post-processing Instructions
First process the locking pin. It needs to be sanded or scraped until it can be pushed snugly into rectangular holes in the mounting block. Next, take your 10-24 screw and attempt to screw it into the hole in the left mounting block. This may require some reaming with a drill bit. Continue into the respective hole on the right mounting block, but stop before you begin drilling past the original depth. This should allow the screw to be installed. Use the screw to tighten the system to the intended picatinny rail. 

## Installation Instructions
Follow the instructions below in the given order. Be sure to take safety precautions before operating any power tools.

### Installing the brace strap
1. The first item on the docket is installing the brace strap. This is rather self explanatory, but may take some persuasion to get the strap to fit. 

### Assembling the main rod
1. The second thing to do is installing the main rod. I recommend cutting to 2 ft 6 in, and after checking length-of-pull and comfort on the arm, cutting the rod to size. (A small amount of sanding or grinding may need to be performed to fit the rod into the holes on either end of each interface.) 
2. Assemble the rods into the fixture, and using a dab of JB Weld or super glue may be used on the brace's rod hole to ensure fitment and strength. 

### Assembling the rail-mounting nuts
1. Put some JB weld or epoxy on the outside rim of the 6-32 hex nuts and drop them into the hexagonal holes on the mounting block. Allow these to cure overnight. 
2. Then install the modular rail using your 6-32 x 3/8" screws.

### Final assembly
At this point your system is ready for use. Install it by simply sliding the mounting block onto the rail of the pistol, placing the locking pin in the appropriate hole, and sliding the block around until the pin can lock in. 

**Pro-tip:** It is recommended to situate the mounting block so the rod lays on the right side of the pistol as not to interfere with normal right handed operation. 

## Credits
I would like to thank the Keybase user sschoor for making some adjustments to the shape of the mounting block where it interfaces the pistol. Huge thanks to InsertMeow as well for adding the angled brace. Thanks as well to nguyenkvvn for helping with the documentation.

## Changelog
* 1.1 Released Brace System with Modular Rail

## License
 MIT License
